console.log('=== SORU BUTONLARI SCRIPT YUKLENDI ===');

console.log('soruKonumlari yuklendi:', window.soruKonumlari);

function soruButonlariOlustur(sayfaNo, containerNo) {
    console.log('=== soruButonlariOlustur CAGRILDI ===', sayfaNo, containerNo);
    
    var container = document.getElementById('questionButtonsContainer' + containerNo);
    console.log('Container:', container);
    
    if (!container) {
        console.log('HATA: Container bulunamadi!');
        return;
    }
    
    container.innerHTML = '';
    
    if (!window.soruKonumlari) {
        console.log('window.soruKonumlari tanimli degil');
        return;
    }
    
    var sayfaKey = 'sayfa_' + (sayfaNo < 10 ? '0' + sayfaNo : sayfaNo);
    var sorular = window.soruKonumlari[sayfaKey];
    
    console.log('Sayfa key:', sayfaKey);
    console.log('Sorular:', sorular);
    
    if (!sorular) {
        console.log('Bu sayfa icin soru yok');
        return;
    }
    
    console.log(sorular.length + ' soru bulundu, butonlar olusturuluyor...');
    
    for (var i = 0; i < sorular.length; i++) {
        var soru = sorular[i];
        
        // BUTON OLUSTUR
        var btn = document.createElement('button');
        btn.className = 'question-answer-btn';
        btn.style.position = 'absolute';
        btn.style.left = soru.x + '%';
        btn.style.top = soru.y + '%';
        btn.style.width = '35px';
        btn.style.height = '35px';
        btn.style.background = 'linear-gradient(135deg, #22c55e, #16a34a)';
        btn.style.color = 'white';
        btn.style.border = '2px solid white';
        btn.style.borderRadius = '8px';
        btn.style.cursor = 'pointer';
        btn.style.zIndex = '100';
        btn.style.display = 'flex';
        btn.style.alignItems = 'center';
        btn.style.justifyContent = 'center';
        btn.style.boxShadow = '0 3px 10px rgba(34, 197, 94, 0.5)';
        btn.innerHTML = '<i class="fas fa-check"></i>';
        btn.title = 'Soru ' + soru.soruNo + ' Cevabini Goster';
        
        // OVERLAY OLUSTUR
        var overlay = document.createElement('div');
        overlay.className = 'question-answer-overlay';
        overlay.style.position = 'absolute';
        overlay.style.left = soru.x + '%';
        overlay.style.top = soru.y + '%';
        overlay.style.width = soru.width + '%';
        overlay.style.height = soru.height + '%';
        overlay.style.backgroundColor = 'rgba(255, 255, 255, 0.98)';
        overlay.style.backdropFilter = 'blur(5px)';
        overlay.style.zIndex = '999';
        overlay.style.display = 'none';
        overlay.style.opacity = '0';
        overlay.style.transition = 'opacity 0.3s ease';
        overlay.style.border = '3px solid #22c55e';
        overlay.style.borderRadius = '12px';
        overlay.style.overflow = 'hidden';
        overlay.style.boxShadow = '0 8px 30px rgba(0,0,0,0.3)';
        overlay.style.pointerEvents = 'auto';
        
        // CEVAP RESMI - TAM SAYFA RESMI AMA CROP EDILMIS
        var img = document.createElement('img');
        var imgSrc = 'pages/images/answers/' + window.kitapNo + '_Cevap_' + (sayfaNo < 10 ? '0' + sayfaNo : sayfaNo) + '.png';
        img.src = imgSrc;
        img.alt = 'Soru ' + soru.soruNo + ' Cevabi';
        
        // Resmi tam sayfa boyutunda goster ama negatif pozisyonla kaydir
        img.style.position = 'absolute';
        img.style.width = (100 / soru.width * 100) + '%';
        img.style.height = (100 / soru.height * 100) + '%';
        img.style.left = '-' + (soru.x / soru.width * 100) + '%';
        img.style.top = '-' + (soru.y / soru.height * 100) + '%';
        img.style.objectFit = 'none';
        img.style.maxWidth = 'none';
        img.style.maxHeight = 'none';
        
        img.onerror = function() {
            console.log('HATA: Resim yuklenemedi:', this.src);
        };
        
        img.onload = function() {
            console.log('Resim yuklendi:', this.src);
        };
        
        // KAPATMA BUTONU
        var closeBtn = document.createElement('button');
        closeBtn.className = 'answer-close-btn';
        closeBtn.style.position = 'absolute';
        closeBtn.style.top = '10px';
        closeBtn.style.right = '10px';
        closeBtn.style.width = '40px';
        closeBtn.style.height = '40px';
        closeBtn.style.background = 'linear-gradient(135deg, #ef4444, #dc2626)';
        closeBtn.style.color = 'white';
        closeBtn.style.border = '2px solid white';
        closeBtn.style.borderRadius = '50%';
        closeBtn.style.cursor = 'pointer';
        closeBtn.style.zIndex = '51';
        closeBtn.style.display = 'flex';
        closeBtn.style.alignItems = 'center';
        closeBtn.style.justifyContent = 'center';
        closeBtn.innerHTML = '<i class="fas fa-times"></i>';
        
        overlay.appendChild(img);
        overlay.appendChild(closeBtn);
        
        // BUTON ONCLICK
        btn.onclick = (function(ovr, buton, soruNumarasi) {
            return function() {
                console.log('Soru ' + soruNumarasi + ' butonu tiklandi!');
                
                // Tum overlay'leri kapat
                var allOverlays = container.querySelectorAll('.question-answer-overlay');
                var allBtns = container.querySelectorAll('.question-answer-btn');
                console.log('Toplam overlay sayisi:', allOverlays.length);
                for (var j = 0; j < allOverlays.length; j++) {
                    allOverlays[j].style.display = 'none';
                    allOverlays[j].style.opacity = '0';
                }
                for (var j = 0; j < allBtns.length; j++) {
                    allBtns[j].style.background = 'linear-gradient(135deg, #22c55e, #16a34a)';
                }
                
                // Bu overlay'i ac
                ovr.style.display = 'block';
                setTimeout(function() {
                    ovr.style.opacity = '1';
                }, 10);
                buton.style.background = 'linear-gradient(135deg, #ef4444, #dc2626)';
                console.log('Soru ' + soruNumarasi + ' cevabi gosteriliyor');
            };
        })(overlay, btn, soru.soruNo);
        
        // CLOSE BUTTON ONCLICK
        closeBtn.onclick = (function(ovr, buton) {
            return function(e) {
                e.stopPropagation();
                ovr.style.opacity = '0';
                setTimeout(function() {
                    ovr.style.display = 'none';
                }, 300);
                buton.style.background = 'linear-gradient(135deg, #22c55e, #16a34a)';
                console.log('Cevap kapatildi');
            };
        })(overlay, btn);
        
        container.appendChild(btn);
        container.appendChild(overlay);
        console.log('Buton ve overlay eklendi: Soru', soru.soruNo);
    }
    
    console.log('=== TOPLAM ' + sorular.length + ' BUTON EKLENDI ===');
}

window.soruButonlariOlustur = soruButonlariOlustur;

console.log('=== FONKSIYON TANIMLANDI ===');

// OTOMATIK CAGRI - 2 saniye sonra
setTimeout(function() {
    console.log('=== OTOMATIK CAGRI BASLIYOR ===');
    
    var container1 = document.getElementById('questionButtonsContainer1');
    console.log('Container1 kontrol:', container1);
    
    if (container1) {
        console.log('Container bulundu, butonlar olusturuluyor...');
        soruButonlariOlustur(1, 1);
    } else {
        console.log('HATA: Container bulunamadi! 1 saniye daha bekleniyor...');
        setTimeout(function() {
            soruButonlariOlustur(1, 1);
        }, 1000);
    }
}, 2000);

