const { app, BrowserWindow, Menu } = require('electron');
const path = require('path');

let mainWindow;

function createWindow() {
    mainWindow = new BrowserWindow({
        width: 1400,
        height: 900,
        fullscreen: false,
        title: '5 Multilingual Akıllı Tahta',
        icon: path.join(__dirname, 'assets', 'icon.png'),
        webPreferences: {
            nodeIntegration: false,
            contextIsolation: true,
            enableRemoteModule: false,
            webSecurity: true
        },
        autoHideMenuBar: true,
        backgroundColor: '#f0f2f5',
        center: true,
        resizable: true,
        minimizable: true,
        maximizable: true
    });

    // Ana menüyü kaldır
    Menu.setApplicationMenu(null);

    // index.html dosyasını yükle
    mainWindow.loadFile('index.html');

    // Pencere kapatıldığında
    mainWindow.on('closed', function () {
        mainWindow = null;
    });
}

// Uygulama hazır olduğunda
app.on('ready', createWindow);

// Tüm pencereler kapatıldığında
app.on('window-all-closed', function () {
    // macOS'ta tipik davranış uygulamanın açık kalmasıdır
    if (process.platform !== 'darwin') {
        app.quit();
    }
});

app.on('activate', function () {
    // macOS'ta dock ikonuna tıklandığında pencereyi tekrar aç
    if (mainWindow === null) {
        createWindow();
    }
});

// F11 ile tam ekran geçişi
app.on('browser-window-created', (e, window) => {
    window.webContents.on('before-input-event', (event, input) => {
        if (input.key === 'F11') {
            mainWindow.setFullScreen(!mainWindow.isFullScreen());
        }
    });
});

