// 1/index.html ile TAM UYUMLU common-functions.js
console.log('Common functions loaded - Çizim araçları hazırlanıyor...');

// Global çizim değişkenleri - 1/index.html ile aynı
window.canvasHistory = {};
window.lastActiveCanvas = 'drawingCanvas';
window.currentTool = 'pen';
window.currentColor = '#FF0000';
window.currentDrawingMode = 'pen';
window.currentDrawingColor = '#FF0000';
window.currentShape = 'circle';
window.lineWidth = 3;
window.dimli = 1;



// Geri bildirim fonksiyonu (devre dışı - sadece console'da gösterilir)
function showFeedback(message, type = 'info') {
    console.log(`${type.toUpperCase()}: ${message}`);
    // Bildirimler devre dışı bırakıldı
}

// Window'a ekle
window.showFeedback = showFeedback;

// Sayfa navigasyon fonksiyonları
function nextPage() {
    if (window.parent && window.parent.nextPage) {
        window.parent.nextPage();
    }
}

function prevPage() {
    if (window.parent && window.parent.prevPage) {
        window.parent.prevPage();
    }
}

function goToPage(pageNum) {
    if (window.parent && window.parent.goToPage) {
        window.parent.goToPage(pageNum);
    }
}

// SAYFA DEĞİŞTİRME FONKSİYONU
function getpage(dim) {
    if (dim < 1 || dim > window.totalPages) return;
    
    window.dimli = dim;
    
    // Sayfa numarasını güncelle
    const pageInput = document.getElementById('current-page-input');
    if (pageInput) pageInput.value = dim;
    
    const drawingPageNumber = document.getElementById('drawing-page-number');
    if (drawingPageNumber) drawingPageNumber.textContent = dim;
    
    // Navigasyon butonlarını güncelle
    const pageDown = document.querySelector('.pagedown');
    const pageUp = document.querySelector('.pageup');
    
    if (pageDown) {
        pageDown.style.visibility = dim <= 1 ? 'hidden' : 'visible';
        pageDown.setAttribute('onclick', 'getpage(' + (dim-1) + ');');
    }
    
    if (pageUp) {
        pageUp.style.visibility = dim >= window.totalPages ? 'hidden' : 'visible';
        pageUp.setAttribute('onclick', 'getpage(' + (dim+1) + ');');
    }
    
    // Sayfa görsellerini güncelle
    const sayfa1 = document.getElementById('sayfa');
    const sayfa2 = document.getElementById('sayfa2');
    const kitapNo = window.kitapNo || '1';
    
    // Çift sayfa modunda farklı davran
    if (window.isDoublePage) {
        // Çift sayfa modunda: mevcut sayfa sol tarafta, bir sonraki sayfa sağ tarafta
        if (sayfa1) {
            sayfa1.src = 'pages/images/' + kitapNo + '_Sayfa_' + String(dim).padStart(2, '0') + '.png';
        }
        
        if (sayfa2) {
            const nextPageNumber = dim + 1;
            const totalPages = window.totalPages || 42;
            
            if (nextPageNumber <= totalPages) {
                sayfa2.src = 'pages/images/' + kitapNo + '_Sayfa_' + String(nextPageNumber).padStart(2, '0') + '.png';
                sayfa2.style.opacity = '1';
                sayfa2.title = 'Sayfa ' + nextPageNumber;
            } else {
                // Son sayfa ise sağ tarafı boş göster
                sayfa2.style.opacity = '0.3';
                sayfa2.title = 'Kitap sonu';
                sayfa2.src = 'pages/images/' + kitapNo + '_Sayfa_' + String(dim).padStart(2, '0') + '.png';
            }
        }
        
        window.lastActiveCanvas = 'drawingCanvas';
    } else {
        // Tek sayfa modunda: sadece ana sayfayı güncelle
        if (sayfa1) {
            sayfa1.src = 'pages/images/' + kitapNo + '_Sayfa_' + String(dim).padStart(2, '0') + '.png';
        }
        
        window.lastActiveCanvas = 'drawingCanvas';
    }
    
    // Canvas'ı yeniden başlat
    setTimeout(() => {
        initCanvasForPage(window.lastActiveCanvas);
    }, 100);
}

// ÖZELLİK BUTONLARI FONKSİYONLARI
function openVideoModal() {
    showFeedback('Video özelliği yakında gelecek!', 'info');
}

function openAudioModal() {
    showFeedback('Ses özelliği yakında gelecek!', 'info');
}

function openPaintingModal() {
    showFeedback('Boyama özelliği yakında gelecek!', 'info');
}

function openActivityModal() {
    showFeedback('Etkinlik özelliği yakında gelecek!', 'info');
}

function openCircleMarkModal() {
    showFeedback('İşaretleme özelliği yakında gelecek!', 'info');
}

// ÇİZİM ARAÇLARI FONKSİYONLARI
function toggleDrawingToolbox() {
    const toolbox = document.getElementById('drawingToolbox');
    if (toolbox) {
        const isHidden = toolbox.classList.contains('hidden') || toolbox.style.display === 'none';
        if (isHidden) {
            toolbox.classList.remove('hidden');
            toolbox.style.display = 'block';
        } else {
            toolbox.classList.add('hidden');
            toolbox.style.display = 'none';
        }
    }
}



function clearDrawing() {
    const canvas = document.getElementById(window.lastActiveCanvas);
    if (!canvas) return false;
    
    const ctx = canvas.getContext('2d');
    
    // Mevcut transform'u kaydet
    const currentTransform = ctx.getTransform();
    
    // Transform'u sıfırla
    ctx.setTransform(1, 0, 0, 1, 0, 0);
    
    // Canvas'ı temizle
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    
    // Transform'u geri yükle
    ctx.setTransform(currentTransform);
    
    // State'i kaydet
    saveCanvasState(window.lastActiveCanvas);
    showFeedback('Çizim temizlendi', 'success');
    return true;
}

function undoDrawing() {
    const canvasId = window.lastActiveCanvas;
    const history = window.canvasHistory[canvasId];
    
    if (!history || history.historyStep <= 0) {
        showFeedback('Geri alınacak işlem yok', 'warning');
        return false;
    }
    
    history.historyStep--;
    const canvas = document.getElementById(canvasId);
    const ctx = canvas.getContext('2d');
    
    const img = new Image();
    img.onload = function() {
        // Mevcut transform'u kaydet
        const currentTransform = ctx.getTransform();
        
        // Transform'u sıfırla
        ctx.setTransform(1, 0, 0, 1, 0, 0);
        
        // Canvas'ı temizle ve resmi çiz
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.drawImage(img, 0, 0);
        
        // Transform'u geri yükle
        ctx.setTransform(currentTransform);
    };
    img.src = history.history[history.historyStep];
    
    showFeedback('Geri alındı', 'success');
    return true;
}

function redoDrawing() {
    const canvasId = window.lastActiveCanvas;
    const history = window.canvasHistory[canvasId];
    
    if (!history || history.historyStep >= history.history.length - 1) {
        showFeedback('İleri alınacak işlem yok', 'warning');
        return false;
    }
    
    history.historyStep++;
    const canvas = document.getElementById(canvasId);
    const ctx = canvas.getContext('2d');
    
    const img = new Image();
    img.onload = function() {
        // Mevcut transform'u kaydet
        const currentTransform = ctx.getTransform();
        
        // Transform'u sıfırla
        ctx.setTransform(1, 0, 0, 1, 0, 0);
        
        // Canvas'ı temizle ve resmi çiz
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.drawImage(img, 0, 0);
        
        // Transform'u geri yükle
        ctx.setTransform(currentTransform);
    };
    img.src = history.history[history.historyStep];
    
    showFeedback('İleri alındı', 'success');
    return true;
}

// Window fonksiyonlarını global yap
window.clearDrawing = clearDrawing;
window.undoDrawing = undoDrawing;
window.redoDrawing = redoDrawing;

function saveDrawing() {
    const canvas = document.getElementById(window.lastActiveCanvas);
    if (!canvas) return;
    
    const dataURL = canvas.toDataURL('image/png');
    const link = document.createElement('a');
    link.download = 'cizim_sayfa_' + window.dimli + '.png';
    link.href = dataURL;
    link.click();
    
    showFeedback('Çizim kaydedildi', 'success');
}

// KONTROL BUTONLARI FONKSİYONLARI
function backToMainMenu() {
    window.location.href = '../index.html';
}

function goToMainMenu() {
    window.location.href = '../index.html';
}

function openBookSelector() {
    showFeedback('Kitap seçici yakında gelecek!', 'info');
}

function toggleFullscreen() {
    if (!document.fullscreenElement) {
        document.documentElement.requestFullscreen().catch(err => {
            showFeedback('Tam ekran açılamadı: ' + err.message, 'error');
        });
    } else {
        document.exitFullscreen();
    }
}

// Window fonksiyonlarını global yap
window.backToMainMenu = backToMainMenu;
window.goToMainMenu = goToMainMenu;
window.openBookSelector = openBookSelector;
window.toggleFullscreen = toggleFullscreen;

function togglePageSelector() {
    const thumbnailPanel = document.getElementById('thumbnailPanel');
    if (!thumbnailPanel) {
        showFeedback('Sayfa seçici paneli bulunamadı!', 'error');
        return;
    }
    
    const isHidden = thumbnailPanel.classList.contains('hidden');
    
    if (isHidden) {
        // Sayfa seçiciyi aç
        thumbnailPanel.classList.remove('hidden');
        if (typeof loadThumbnails === 'function') {
            loadThumbnails();
        }
        showFeedback('📖 Sayfa seçici açıldı - Sayfa görsellerine tıklayarak istediğiniz sayfaya gidebilirsiniz', 'info');
    } else {
        // Sayfa seçiciyi kapat
        thumbnailPanel.classList.add('hidden');
        showFeedback('📖 Sayfa seçici kapatıldı', 'info');
    }
}

function jumpToCurrentPage() {
    const input = document.getElementById('current-page-input');
    if (input) {
        const pageNum = parseInt(input.value);
        if (pageNum >= 1 && pageNum <= window.totalPages) {
            getpage(pageNum);
        } else {
            showFeedback('Geçersiz sayfa numarası!', 'error');
        }
    }
}

// Zoom değişkenleri
window.currentZoom = 1;
window.minZoom = 0.5;
window.maxZoom = 3;
window.zoomStep = 0.25;

function zoomPageIn() {
    if (window.currentZoom < window.maxZoom) {
        window.currentZoom += window.zoomStep;
        applyZoom();
        showFeedback('Yakınlaştırıldı: %' + Math.round(window.currentZoom * 100), 'info');
    } else {
        showFeedback('Maksimum yakınlaştırma seviyesine ulaşıldı!', 'warning');
    }
}

function zoomPageOut() {
    if (window.currentZoom > window.minZoom) {
        window.currentZoom -= window.zoomStep;
        applyZoom();
        showFeedback('Uzaklaştırıldı: %' + Math.round(window.currentZoom * 100), 'info');
    } else {
        showFeedback('Minimum uzaklaştırma seviyesine ulaşıldı!', 'warning');
    }
}

function resetPageZoom() {
    window.currentZoom = 1;
    applyZoom();
    showFeedback('Zoom normal seviyeye sıfırlandı (%100)', 'success');
}

function applyZoom() {
    const pageContainer = document.getElementById('pageContainer');
    if (pageContainer) {
        pageContainer.style.transform = 'scale(' + window.currentZoom + ')';
        pageContainer.style.transformOrigin = 'center center';
        
        // Zoom seviyesine göre container boyutunu ayarla
        const containerParent = pageContainer.parentElement;
        if (containerParent && window.currentZoom !== 1) {
            containerParent.style.overflow = 'auto';
            containerParent.style.display = 'flex';
            containerParent.style.justifyContent = 'center';
            containerParent.style.alignItems = 'center';
        } else if (containerParent) {
            containerParent.style.overflow = 'visible';
        }
    }
}

// GERİ BİLDİRİM FONKSİYONU (devre dışı - sadece console'da gösterilir)
function showFeedback(message, type = 'info') {
    console.log(type.toUpperCase() + ': ' + message);
    // Bildirimler devre dışı bırakıldı
}

// CANVAS İÇİN İNİT FONKSİYONU
function initCanvasForPage(canvasId) {
    const canvas = document.getElementById(canvasId);
    if (!canvas) return;
    
    const container = canvas.parentElement;
    const img = container.querySelector('img');
    
    if (img) {
        // Canvas boyutunu resme göre ayarla
        canvas.width = img.width;
        canvas.height = img.height;
        
        const ctx = canvas.getContext('2d');
        ctx.scale(2, 2);
        ctx.lineCap = 'round';
        ctx.lineJoin = 'round';
        
        // Canvas geçmişini başlat
        if (!window.canvasHistory[canvasId]) {
            window.canvasHistory[canvasId] = {
                history: [],
                historyStep: -1,
                maxHistory: 15
            };
        }
        
        // İlk boş state'i kaydet
        saveCanvasState(canvasId);
        
        // Çizim event'lerini başlat
        initDirectDrawing(canvas);
    }
}

// SAYFA DEĞİŞTİĞİNDE TÜM ÇİZİMLERİ TEMİZLE
function clearAllDrawings() {
    // Tüm canvas'ları temizle
    const allCanvases = ['drawingCanvas', 'drawingCanvas2'];
    
    allCanvases.forEach(canvasId => {
        const canvas = document.getElementById(canvasId);
        if (canvas) {
            const ctx = canvas.getContext('2d');
            // Canvas'ı tamamen temizle
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            
            // Canvas history'sini sıfırla
            window.canvasHistory[canvasId] = {
                history: [],
                historyStep: -1,
                maxHistory: 15
            };
            
            // Event listener flag'ini sıfırla
            canvas._drawingEventsAttached = false;
            
            // Boş state'i kaydet
            if (typeof saveCanvasState === 'function') {
                saveCanvasState(canvasId);
            }
            
            console.log(`🧹 Canvas temizlendi: ${canvasId}`);
        }
    });
    
    // Çizim modlarını sıfırla
    window.lastActiveCanvas = 'drawingCanvas';
    
    console.log('✅ Tüm çizimler temizlendi - Yeni sayfa için hazır!');
}

// Canvas state kaydet
function saveCanvasState(canvasId) {
    const canvas = document.getElementById(canvasId);
    if (!canvas || !window.canvasHistory[canvasId]) return;

    const history = window.canvasHistory[canvasId];
    
    // Canvas'ın mevcut transform state'ini geçici olarak kaydet
    const ctx = canvas.getContext('2d');
    const currentTransform = ctx.getTransform();
    
    // Geçici olarak transform'u sıfırla
    ctx.setTransform(1, 0, 0, 1, 0, 0);
    
    // DataURL al
    const dataURL = canvas.toDataURL();
    
    // Transform'u geri yükle
    ctx.setTransform(currentTransform);

    // Eğer redo işleminden sonra yeni bir state kaydediliyorsa
    // redo history'sini temizle
    if (history.historyStep < history.history.length - 1) {
        history.history = history.history.slice(0, history.historyStep + 1);
    }

    // Yeni state'i ekle
    history.history.push(dataURL);
    history.historyStep = history.history.length - 1;

    // Max history sınırı
    if (history.history.length > history.maxHistory) {
        history.history.shift();
        history.historyStep--;
    }

    console.log('📝 State kaydedildi: ' + canvasId + ' (step: ' + history.historyStep + '/' + (history.history.length - 1) + ')');
}

// Çizim araçları
function initDrawingTools() {
    console.log('Drawing tools initialized');
    
    // Canvas history sistemini başlat
    const allCanvases = document.querySelectorAll('canvas[id*="drawing"]');
    allCanvases.forEach(canvas => {
        if (!window.canvasHistory[canvas.id]) {
            window.canvasHistory[canvas.id] = {
                history: [],
                historyStep: -1,
                maxHistory: 15
            };
        }
    });
    
    // Büyüteç butonu için özel event listener
    const magnifierBtn = document.querySelector('.magnifier-tool-btn');
    if (magnifierBtn) {
        // Önce mevcut event listener'ları temizle
        const newMagnifierBtn = magnifierBtn.cloneNode(true);
        magnifierBtn.parentNode.replaceChild(newMagnifierBtn, magnifierBtn);
        
        newMagnifierBtn.addEventListener('click', (e) => {
            e.preventDefault();
            e.stopPropagation();
            console.log('🔍 Büyüteç butonu tıklandı');
            
            if (typeof window.toggleMagnifier === 'function') {
                window.toggleMagnifier();
            } else {
                console.error('❌ toggleMagnifier fonksiyonu bulunamadı!');
            }
        });
        console.log('✅ Büyüteç butonu event listener eklendi');
    }
    
    // Araç butonlarına event listener ekle
    document.querySelectorAll('.drawing-tool-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            // Büyüteç butonu ise özel işlem yap
            if (this.classList.contains('magnifier-tool-btn')) {
                return; // Büyüteç butonu için ayrı event listener var
            }

            // Büyüteç aktifse önce kapat
            if (window.magnifierActive && typeof window.deactivateMagnifier === 'function') {
                window.deactivateMagnifier();
            }
            
            // Aktif sınıfı güncelle
            document.querySelectorAll('.drawing-tool-btn').forEach(b => b.classList.remove('active'));
            document.querySelectorAll('.shape-tool-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            // Aracı güncelle
            window.currentTool = this.dataset.tool;
            window.currentDrawingMode = this.dataset.tool;
            showFeedback('Araç seçildi: ' + (this.title || this.dataset.tool), 'info');
            console.log('Araç değiştirildi:', window.currentTool);
        });
    });
    
    // Renk butonlarına event listener ekle
    document.querySelectorAll('.color-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            // Aktif sınıfı güncelle
            document.querySelectorAll('.color-btn').forEach(b => {
                b.classList.remove('active');
                const checkIcon = b.querySelector('.fa-check');
                if (checkIcon) checkIcon.style.display = 'none';
            });
            this.classList.add('active');
            const checkIcon = this.querySelector('.fa-check');
            if (checkIcon) checkIcon.style.display = 'block';
            
            // Rengi güncelle
            window.currentColor = this.dataset.color;
            showFeedback('Renk seçildi: ' + (this.title || this.dataset.color), 'info');
            console.log('Renk değiştirildi:', window.currentColor);
        });
    });
    
    // Şekil butonlarına event listener ekle - 1/index.html ile aynı mantık
    document.querySelectorAll('.shape-tool-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            // Büyüteç aktifse önce kapat
            if (window.magnifierActive && typeof window.deactivateMagnifier === 'function') {
                window.deactivateMagnifier();
            }
            
            // Tüm araç butonlarını ve şekil butonlarını temizle
            document.querySelectorAll('.drawing-tool-btn').forEach(b => b.classList.remove('active'));
            document.querySelectorAll('.shape-tool-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            // Şekil aracını aktif et - 1/index.html ile aynı
            const shape = this.dataset.shape;
            window.currentTool = 'shape';
            window.currentShape = shape;
            window.currentDrawingMode = 'shape';
            
            const shapeNames = {
                'arrow': 'Ok',
                'circle': 'Daire',
                'filledcircle': 'Dolu Daire',
                'rectangle': 'Dikdörtgen',
                'triangle': 'Üçgen'
            };
            
            console.log('🔷 Şekil seçildi:', shape);
            if (window.showFeedback) {
                window.showFeedback(`🔷 ${shapeNames[shape]} şekli seçildi`, 'info');
            }
        });
    });
    
    // Kontrol butonlarına event listener ekle
    const clearBtn = document.querySelector('.clear-btn');
    if (clearBtn) {
        clearBtn.addEventListener('click', function(e) {
            e.preventDefault();
            clearDrawing();
        });
    }
    
    const undoBtn = document.querySelector('.undo-btn');
    if (undoBtn) {
        undoBtn.addEventListener('click', function(e) {
            e.preventDefault();
            undoDrawing();
        });
    }
    
    const redoBtn = document.querySelector('.redo-btn');
    if (redoBtn) {
        redoBtn.addEventListener('click', function(e) {
            e.preventDefault();
            redoDrawing();
        });
    }
    
    const saveBtn = document.querySelector('.save-btn');
    if (saveBtn) {
        saveBtn.addEventListener('click', function(e) {
            e.preventDefault();
            saveDrawing();
        });
    }
}

// Gelişmiş çizim araçları başlatma
function initializeDrawingTools() {
    console.log('🎨 Gelişmiş çizim sistemi başlatılıyor...');
    
    // Canvas'ları al ve history ile başlat
    const canvas1 = document.getElementById('drawingCanvas');
    const canvas2 = document.getElementById('drawingCanvas2');
    
    // Ana canvas'ı her zaman ayarla
    if (canvas1) {
        setupDrawingCanvasWithHistory(canvas1, 'sayfa');
        console.log('✅ Ana canvas history ile hazır');
    }
    
    // İkinci canvas'ı sadece çift sayfa modunda veya görünürse ayarla
    if (canvas2 && (!canvas2.classList.contains('hidden') || window.isDoublePage)) {
        setupDrawingCanvasWithHistory(canvas2, 'sayfa2');
        console.log('✅ İkinci canvas history ile hazır');
    }
    
    // Çizim araç butonlarını bağla (sadece bir kez)
    if (!window._drawingButtonsInitialized) {
        setupDrawingButtons();
        window._drawingButtonsInitialized = true;
    }
    
    console.log('🎨 Gelişmiş undo/redo sistemi hazır!');
    console.log('🎯 Canvas history:', Object.keys(window.canvasHistory));
    console.log('🎯 Aktif canvas:', window.lastActiveCanvas);
    
    if (window.showFeedback) {
        window.showFeedback('🎨 Çizim sistemi aktif! Ctrl+Z ile geri al.', 'success');
    }
}

// Canvas ayarlama fonksiyonu - history ile
function setupDrawingCanvasWithHistory(canvas, imageId) {
    const img = document.getElementById(imageId);
    if (!img || !canvas) {
        console.warn('⚠️ Canvas veya görsel bulunamadı:', { canvas: !!canvas, img: !!img, imageId });
        return;
    }

    // Canvas ID'sini ayarla
    const canvasId = canvas.id || `canvas_${imageId}_${Date.now()}`;
    canvas.id = canvasId;

    // History başlat veya sıfırla
    window.canvasHistory[canvasId] = {
        history: [],
        historyStep: -1,
        maxHistory: 15
    };

    // Canvas boyutlarını ayarla
    function resizeCanvas() {
        // Görsel yüklenmesini bekle
        if (!img.complete || img.naturalWidth === 0) {
            setTimeout(resizeCanvas, 100);
            return;
        }
        
        // Image'in base (zoom'suz) boyutunu al
        const baseWidth = img.offsetWidth;
        const baseHeight = img.offsetHeight;
        
        // Geçerli boyut kontrolü
        if (baseWidth === 0 || baseHeight === 0) {
            console.warn('⚠️ Görsel boyutu sıfır, tekrar denenecek:', imageId);
            setTimeout(resizeCanvas, 100);
            return;
        }
        
        // Canvas boyutlarını ayarla - SABİT BOYUT
        canvas.style.position = 'absolute';
        canvas.style.top = '0px';
        canvas.style.left = '0px';
        canvas.style.width = baseWidth + 'px';
        canvas.style.height = baseHeight + 'px';
        canvas.style.zIndex = '10';
        canvas.style.pointerEvents = 'auto';
        canvas.width = baseWidth * 2; // Retina desteği
        canvas.height = baseHeight * 2;
        
        // Context'i yeniden ayarla
        const ctx = canvas.getContext('2d');
        ctx.scale(2, 2);
        ctx.lineCap = 'round';
        ctx.lineJoin = 'round';
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        // İlk boş durumu kaydet
        if (window.canvasHistory[canvasId].history.length === 0) {
            saveCanvasState(canvasId);
            console.log(`✅ Canvas başlatıldı: ${canvasId} (${baseWidth}x${baseHeight})`);
        }
        
        // Çizim event'erini ekle
        initDirectDrawing(canvas);
        
        console.log(`✅ Canvas hazır: ${canvasId}`);
    }

    // Görsel yüklü mü kontrol et
    if (img.complete && img.naturalWidth > 0) {
        resizeCanvas();
    } else {
        // Görsel yüklenmesini bekle
        img.onload = resizeCanvas;
        img.onerror = function() {
            console.error('❌ Görsel yüklenemedi:', imageId);
        };
        
        // Güvenlik için timeout ekle
        setTimeout(function() {
            if (!img.complete) {
                console.warn('⚠️ Görsel yüklenmesi uzun sürüyor, zorla başlatılıyor:', imageId);
                resizeCanvas();
            }
        }, 1000);
    }

    canvas.style.display = 'block';
    canvas.classList.add('active');

    console.log('✅ Canvas history sistemi kuruldu:', canvasId);
}

// Çizim araç butonlarını ayarlama
function setupDrawingButtons() {
    // Bu fonksiyon initDrawingTools içinde çağrılacak
    setTimeout(() => {
        initDrawingTools();
    }, 100);
}

// Ses oynatma
function playSound(soundFile) {
    const audio = new Audio(soundFile);
    audio.play().catch(e => console.log('Ses oynatılamadı:', e));
}

// Video oynatma
function playVideo(videoFile) {
    const video = document.createElement('video');
    video.src = videoFile;
    video.controls = true;
    video.autoplay = true;
    showVideoModal(video);
}

function showVideoModal(video) {
    const modal = document.createElement('div');
    modal.className = 'video-modal';
    modal.innerHTML = '<div class="video-container">' +
        '<button class="close-video" onclick="closeVideoModal()">&times;</button>' +
        video.outerHTML +
        '</div>';
    document.body.appendChild(modal);
}

function closeVideoModal() {
    const modal = document.getElementById('videoModal');
    if (modal) {
        modal.style.display = 'none';
        const video = modal.querySelector('video');
        if (video) video.pause();
    }
}

function closeAudioModal() {
    const modal = document.getElementById('audioModal');
    if (modal) {
        modal.style.display = 'none';
    }
}

function closeBookSelector() {
    const modal = document.getElementById('bookSelectorModal');
    if (modal) {
        modal.style.display = 'none';
    }
}

function toggleDoublePage() {
    const pageContainer = document.getElementById('pageContainer');
    const sayfa2 = document.getElementById('sayfa2');
    const pageContainer2 = document.getElementById('pageCanvasContainer2');
    const canvas2 = document.getElementById('drawingCanvas2');
    const button = document.querySelector('.double-page-btn');
    
    // Çift sayfa modu durumunu toggle et
    window.isDoublePage = !window.isDoublePage;
    
    if (window.isDoublePage) {
        // Çift sayfa modunu aç
        if (pageContainer) pageContainer.classList.add('double-page-mode');
        if (sayfa2) sayfa2.classList.remove('hidden');
        if (pageContainer2) pageContainer2.classList.remove('hidden');
        if (canvas2) {
            canvas2.classList.remove('hidden');
            canvas2.style.display = 'block';
            canvas2._drawingEventsAttached = false; // Event flag'ini sıfırla
        }
        if (button) {
            button.innerHTML = '<i class="fas fa-book"></i> Tek Sayfa';
            button.title = 'Tek Sayfa Görünümüne Geç';
        }
        
                // İkinci sayfayı güncelle
        updateSecondPage();
        
        // Çift sayfa modu için CSS düzenlemelerini ekle
        addDoublePageStyles();
        
        // İkinci canvas'ı da başlat
        setTimeout(function() {
            if (canvas2 && sayfa2) {
                setupDrawingCanvasWithHistory(canvas2, 'sayfa2');
                console.log('✅ Çift sayfa modunda ikinci canvas başlatıldı');
            }
        }, 500);
        
        const currentPageNumber = window.dimli || 1;
        const nextPageNumber = currentPageNumber + 1;
        const totalPages = window.totalPages || 42;
        
         if (nextPageNumber <= totalPages) {
             showFeedback('📖 Çift sayfa görünümü açıldı! Sayfa ' + currentPageNumber + '-' + nextPageNumber + ' gösteriliyor', 'success');
         } else {
             showFeedback('📖 Çift sayfa görünümü açıldı! Son sayfa: ' + currentPageNumber, 'success');
         }
    } else {
        // Tek sayfa moduna geç
        if (pageContainer) pageContainer.classList.remove('double-page-mode');
        if (sayfa2) sayfa2.classList.add('hidden');
        if (pageContainer2) pageContainer2.classList.add('hidden');
        if (canvas2) canvas2.classList.add('hidden');
        if (button) {
            button.innerHTML = '<i class="fas fa-book-open"></i> Çift Sayfa';
            button.title = 'Çift Sayfa Görünümüne Geç';
        }
        
        // Çift sayfa CSS stillerini kaldır
        removeDoublePageStyles();
        
        showFeedback('📖 Tek sayfa görünümüne geçildi', 'success');
    }
}

// İkinci sayfa güncelleme fonksiyonu
function updateSecondPage() {
    const sayfa2 = document.getElementById('sayfa2');
    if (!sayfa2) return;
    
    const currentPageNumber = window.dimli || 1;
    const nextPageNumber = currentPageNumber + 1;
    const totalPages = window.totalPages || 42;
    const kitapNo = window.kitapNo || '1';
    
    const canvas2 = document.getElementById('drawingCanvas2');
    if (canvas2) {
        const ctx2 = canvas2.getContext('2d');
        ctx2.clearRect(0, 0, canvas2.width, canvas2.height);
        
        if (window.canvasHistory && window.canvasHistory['drawingCanvas2']) {
            window.canvasHistory['drawingCanvas2'] = {
                history: [],
                historyStep: -1,
                maxHistory: 10
            };
            if (typeof saveCanvasState === 'function') {
                saveCanvasState('drawingCanvas2');
            }
        }
    }
    
         if (nextPageNumber <= totalPages) {
         sayfa2.src = 'pages/images/' + kitapNo + '_Sayfa_' + (nextPageNumber < 10 ? '0' + nextPageNumber : nextPageNumber) + '.png';
         sayfa2.style.opacity = '1';
         sayfa2.title = 'Sayfa ' + nextPageNumber;
     } else {
         // Son sayfa ise sağ tarafı boş göster
         sayfa2.style.opacity = '0.3';
         sayfa2.title = 'Kitap sonu';
         sayfa2.src = 'pages/images/' + kitapNo + '_Sayfa_' + (currentPageNumber < 10 ? '0' + currentPageNumber : currentPageNumber) + '.png'; // Aynı resmi koy ama şeffaf
     }
}

// Çift sayfa modu için özel CSS stilleri ekle
function addDoublePageStyles() {
    // Mevcut stil varsa kaldır
    const existingStyle = document.getElementById('double-page-custom-styles');
    if (existingStyle) {
        existingStyle.remove();
    }
    
    const style = document.createElement('style');
    style.id = 'double-page-custom-styles';
    style.textContent = 
        '/* ULTRA GÜÇ - Çift sayfa modunda maksimum boyut */' +
        'body .maindiv .main-content .page-display .page .page-container.double-page-mode {' +
            'display: flex !important;' +
            'align-items: center !important;' +
            'justify-content: center !important;' +
            'gap: 20px !important;' +
            'width: 100% !important;' +
            'height: 100% !important;' +
            'max-width: 100% !important;' +
            'max-height: 100% !important;' +
            'padding: 5px !important;' +
            'box-sizing: border-box !important;' +
            'position: relative !important;' +
        '}' +
        'body .maindiv .main-content .page-display .page {' +
            'width: 100% !important;' +
            'height: 100% !important;' +
            'max-width: 100% !important;' +
            'max-height: 100% !important;' +
        '}' +
        'body .maindiv .main-content .page-display {' +
            'width: 100% !important;' +
            'height: 100% !important;' +
            'max-width: 100% !important;' +
            'max-height: 100% !important;' +
        '}' +
        'body .maindiv .main-content {' +
            'width: 100% !important;' +
            'height: 100vh !important;' +
            'max-width: 100% !important;' +
            'max-height: 100vh !important;' +
        '}' +
        'body .page-container.double-page-mode .page-canvas-container,' +
        'body .page-container.double-page-mode #pageCanvasContainer1,' +
        'body .page-container.double-page-mode #pageCanvasContainer2 {' +
            'width: 48% !important;' +
            'height: 95% !important;' +
            'max-width: 48% !important;' +
            'max-height: 95% !important;' +
            'flex: 0 0 48% !important;' +
            'display: flex !important;' +
            'align-items: center !important;' +
            'justify-content: center !important;' +
            'position: relative !important;' +
            'overflow: visible !important;' +
        '}' +
        'body .page-container.double-page-mode #sayfa,' +
        'body .page-container.double-page-mode #sayfa2 {' +
            'width: 100% !important;' +
            'height: 100% !important;' +
            'max-width: none !important;' +
            'max-height: none !important;' +
            'object-fit: contain !important;' +
            'transform: scale(1) !important;' +
            'display: block !important;' +
            'position: relative !important;' +
            'z-index: 1 !important;' +
        '}' +
        '/* Canvas boyutlarını da ayarla */' +
        'body .page-container.double-page-mode .drawing-canvas,' +
        'body .page-container.double-page-mode #drawingCanvas,' +
        'body .page-container.double-page-mode #drawingCanvas2 {' +
            'width: 100% !important;' +
            'height: 100% !important;' +
            'position: absolute !important;' +
            'top: 0 !important;' +
            'left: 0 !important;' +
            'z-index: 10 !important;' +
            'pointer-events: auto !important;' +
        '}' +
        '/* Tüm mevcut CSS kurallarını ezmek için */' +
        '.page-container.double-page-mode * {' +
            'box-sizing: border-box !important;' +
        '}';
    
    document.head.appendChild(style);
    
    // JavaScript ile de direkt stil değişiklikleri yap
    setTimeout(function() {
        applyDoublePageDirectStyles();
    }, 100);
    
    // Ek olarak bir kez daha 500ms sonra uygula
    setTimeout(function() {
        applyDoublePageDirectStyles();
    }, 500);
    
    console.log('✅ Çift sayfa CSS stilleri eklendi');
}

// Direkt JavaScript ile stil değişiklikleri - AGRESIF YAKLAŞIM
function applyDoublePageDirectStyles() {
    const pageContainer = document.getElementById('pageContainer');
    const container1 = document.getElementById('pageCanvasContainer1');
    const container2 = document.getElementById('pageCanvasContainer2');
    const sayfa1 = document.getElementById('sayfa');
    const sayfa2 = document.getElementById('sayfa2');
    const canvas1 = document.getElementById('drawingCanvas');
    const canvas2 = document.getElementById('drawingCanvas2');
    
    // Page Container - Tam ekran kullanımı
    if (pageContainer) {
        pageContainer.style.setProperty('display', 'flex', 'important');
        pageContainer.style.setProperty('align-items', 'center', 'important');
        pageContainer.style.setProperty('justify-content', 'center', 'important');
        pageContainer.style.setProperty('gap', '20px', 'important');
        pageContainer.style.setProperty('width', '100%', 'important');
        pageContainer.style.setProperty('height', '100%', 'important');
        pageContainer.style.setProperty('max-width', '100%', 'important');
        pageContainer.style.setProperty('max-height', '100%', 'important');
        pageContainer.style.setProperty('padding', '5px', 'important');
        pageContainer.style.setProperty('box-sizing', 'border-box', 'important');
    }
    
    // Container boyutlarını maksimuma çıkar
    [container1, container2].forEach(function(container) {
        if (container) {
            container.style.setProperty('width', '48%', 'important');
            container.style.setProperty('height', '95%', 'important');
            container.style.setProperty('max-width', '48%', 'important');
            container.style.setProperty('max-height', '95%', 'important');
            container.style.setProperty('flex', '0 0 48%', 'important');
            container.style.setProperty('display', 'flex', 'important');
            container.style.setProperty('align-items', 'center', 'important');
            container.style.setProperty('justify-content', 'center', 'important');
            container.style.setProperty('position', 'relative', 'important');
            container.style.setProperty('overflow', 'visible', 'important');
        }
    });
    
    // Sayfa görsellerini maksimum boyutta yap
    [sayfa1, sayfa2].forEach(function(sayfa, index) {
        if (sayfa) {
            sayfa.style.setProperty('width', '100%', 'important');
            sayfa.style.setProperty('height', '100%', 'important');
            sayfa.style.setProperty('max-width', 'none', 'important');
            sayfa.style.setProperty('max-height', 'none', 'important');
            sayfa.style.setProperty('object-fit', 'contain', 'important');
            sayfa.style.setProperty('transform', 'scale(1)', 'important');
            sayfa.style.setProperty('display', 'block', 'important');
            sayfa.style.setProperty('position', 'relative', 'important');
            sayfa.style.setProperty('z-index', '1', 'important');
            
            // Sayfa görselinin gerçek boyutunu kontrol et ve ayarla
            var img = new Image();
            img.onload = function() {
                var containerRect = sayfa.parentElement.getBoundingClientRect();
                var aspectRatio = this.naturalWidth / this.naturalHeight;
                var containerAspectRatio = containerRect.width / containerRect.height;
                
                if (aspectRatio > containerAspectRatio) {
                    // Görsel daha geniş - genişliği container'a sığdır
                    sayfa.style.setProperty('width', '100%', 'important');
                    sayfa.style.setProperty('height', 'auto', 'important');
                } else {
                    // Görsel daha uzun - yüksekliği container'a sığdır  
                    sayfa.style.setProperty('width', 'auto', 'important');
                    sayfa.style.setProperty('height', '100%', 'important');
                }
            };
            img.src = sayfa.src;
        }
    });
    
    // Canvas'ları da ayarla
    [canvas1, canvas2].forEach(function(canvas) {
        if (canvas) {
            canvas.style.setProperty('width', '100%', 'important');
            canvas.style.setProperty('height', '100%', 'important');
            canvas.style.setProperty('position', 'absolute', 'important');
            canvas.style.setProperty('top', '0', 'important');
            canvas.style.setProperty('left', '0', 'important');
            canvas.style.setProperty('z-index', '10', 'important');
            canvas.style.setProperty('pointer-events', 'auto', 'important');
        }
    });
    
    // Ana container'ın parent'ını da ayarla
    var mainContent = document.querySelector('.main-content');
    var pageDisplay = document.querySelector('.page-display');
    var page = document.querySelector('.page');
    
    if (mainContent) {
        mainContent.style.setProperty('width', '100%', 'important');
        mainContent.style.setProperty('height', '100vh', 'important');
        mainContent.style.setProperty('max-width', '100%', 'important');
        mainContent.style.setProperty('max-height', '100vh', 'important');
    }
    
    if (pageDisplay) {
        pageDisplay.style.setProperty('width', '100%', 'important');
        pageDisplay.style.setProperty('height', '100%', 'important');
        pageDisplay.style.setProperty('max-width', '100%', 'important');
        pageDisplay.style.setProperty('max-height', '100%', 'important');
    }
    
    if (page) {
        page.style.setProperty('width', '100%', 'important');
        page.style.setProperty('height', '100%', 'important');
        page.style.setProperty('max-width', '100%', 'important');
        page.style.setProperty('max-height', '100%', 'important');
    }
    
    console.log('✅ Agresif stil değişiklikleri uygulandı');
}

// Çift sayfa CSS stillerini kaldır
function removeDoublePageStyles() {
    const existingStyle = document.getElementById('double-page-custom-styles');
    if (existingStyle) {
        existingStyle.remove();
    }
    
    // Direkt stilleri de temizle
    setTimeout(function() {
        restoreSinglePageStyles();
    }, 100);
    
    console.log('✅ Çift sayfa CSS stilleri kaldırıldı');
}

// Tek sayfa moduna dönüş için stilleri geri yükle
function restoreSinglePageStyles() {
    const pageContainer = document.getElementById('pageContainer');
    const container1 = document.getElementById('pageCanvasContainer1');
    const container2 = document.getElementById('pageCanvasContainer2');
    const sayfa1 = document.getElementById('sayfa');
    const sayfa2 = document.getElementById('sayfa2');
    const canvas1 = document.getElementById('drawingCanvas');
    const canvas2 = document.getElementById('drawingCanvas2');
    
    if (pageContainer) {
        pageContainer.style.cssText = pageContainer.style.cssText
            .replace(/display: flex !important;/g, '')
            .replace(/align-items: center !important;/g, '')
            .replace(/justify-content: center !important;/g, '')
            .replace(/gap: 15px !important;/g, '')
            .replace(/width: 98% !important;/g, '')
            .replace(/height: 95% !important;/g, '')
            .replace(/max-width: 98% !important;/g, '')
            .replace(/max-height: 95% !important;/g, '')
            .replace(/padding: 10px !important;/g, '');
    }
    
    [container1, container2].forEach(function(container) {
        if (container) {
            container.style.cssText = container.style.cssText
                .replace(/width: 47% !important;/g, '')
                .replace(/height: 100% !important;/g, '')
                .replace(/max-width: 47% !important;/g, '')
                .replace(/max-height: 100% !important;/g, '')
                .replace(/flex: 0 0 47% !important;/g, '')
                .replace(/display: flex !important;/g, '')
                .replace(/align-items: center !important;/g, '')
                .replace(/justify-content: center !important;/g, '');
        }
    });
    
    [sayfa1, sayfa2].forEach(function(sayfa) {
        if (sayfa) {
            sayfa.style.cssText = sayfa.style.cssText
                .replace(/width: 100% !important;/g, '')
                .replace(/height: auto !important;/g, '')
                .replace(/max-width: none !important;/g, '')
                .replace(/max-height: none !important;/g, '')
                .replace(/object-fit: contain !important;/g, '')
                .replace(/transform: scale(1) !important;/g, '');
        }
    });
    
    [canvas1, canvas2].forEach(function(canvas) {
        if (canvas) {
            canvas.style.cssText = canvas.style.cssText
                .replace(/width: 100% !important;/g, '')
                .replace(/height: 100% !important;/g, '')
                .replace(/position: absolute !important;/g, '')
                .replace(/top: 0 !important;/g, '')
                .replace(/left: 0 !important;/g, '');
        }
    });
    
    console.log('✅ Tek sayfa stilleri geri yüklendi');
}

function playPageAudio(speed) {
    showFeedback(`${speed} hızında ses oynatma yakında gelecek!`, 'info');
}

function playBackgroundMusic(type) {
    showFeedback(`${type} arka plan müziği yakında gelecek!`, 'info');
}

function stopBackgroundMusic() {
    showFeedback('Müzik durdurma yakında gelecek!', 'info');
}

// Yüklenme animasyonu
function showLoader() {
    const loader = document.getElementById('_preload_div_');
    if (loader) loader.style.display = 'block';
}

function hideLoader() {
    const loader = document.getElementById('_preload_div_');
    if (loader) loader.style.display = 'none';
}

// Thumbnail yükleme fonksiyonu
function loadThumbnails() {
    const thumbsContainer = document.getElementById('Thumbs');
    if (!thumbsContainer) return;
    
    thumbsContainer.innerHTML = '';
    
    const totalPages = window.totalPages || 42;
    const kitapNo = window.kitapNo || '1';
    
    for (let i = 1; i <= totalPages; i++) {
        const thumbDiv = document.createElement('div');
        thumbDiv.className = 'thumbnail-item';
        thumbDiv.dataset.pageNumber = i;
        
        // Tıklama olayını addEventListener ile ekle
        thumbDiv.addEventListener('click', (e) => {
            e.stopPropagation();
            getpage(i);
            togglePageSelector();
        });
        
        const thumbImg = document.createElement('img');
        thumbImg.src = 'thumbs/thmb_Sayfa_' + (i < 10 ? '0' + i : i) + '.png';
        thumbImg.alt = 'Sayfa ' + i;
        thumbImg.title = 'Sayfa ' + i;
        
        const thumbLabel = document.createElement('div');
        thumbLabel.className = 'thumbnail-label';
        thumbLabel.textContent = i;
        
        thumbDiv.appendChild(thumbImg);
        thumbDiv.appendChild(thumbLabel);
        thumbsContainer.appendChild(thumbDiv);
    }
    
    // Mouse ile sürükleyerek kaydırma işlevi
    initializeThumbnailDragging(thumbsContainer);
}

// Thumbnail container'ı için mouse sürükleme işlevi
function initializeThumbnailDragging(container) {
    let isDown = false;
    let startX;
    let scrollLeft;
    let hasMoved = false;
    let clickStartTime = 0;
    
    // Mouse olayları
    container.addEventListener('mousedown', (e) => {
        isDown = true;
        hasMoved = false;
        clickStartTime = Date.now();
        container.classList.add('dragging');
        startX = e.pageX - container.offsetLeft;
        scrollLeft = container.scrollLeft;
        e.preventDefault();
    });
    
    container.addEventListener('mouseleave', () => {
        isDown = false;
        container.classList.remove('dragging');
    });
    
    container.addEventListener('mouseup', (e) => {
        isDown = false;
        container.classList.remove('dragging');
        
        if (!hasMoved && (Date.now() - clickStartTime) < 200) {
            const thumbnailItem = e.target.closest('.thumbnail-item');
            if (thumbnailItem) {
                thumbnailItem.click();
            }
        }
    });
    
    container.addEventListener('mousemove', (e) => {
        if (!isDown) return;
        e.preventDefault();
        
        const x = e.pageX - container.offsetLeft;
        const walk = (x - startX) * 2;
        const newScrollLeft = scrollLeft - walk;
        
        if (Math.abs(walk) > 5) {
            hasMoved = true;
            container.scrollLeft = newScrollLeft;
        }
    });
    
    // Touch olayları (mobil için)
    let touchStartX = 0;
    let touchScrollLeft = 0;
    let touchHasMoved = false;
    let touchStartTime = 0;
    
    container.addEventListener('touchstart', (e) => {
        touchStartX = e.touches[0].pageX;
        touchScrollLeft = container.scrollLeft;
        touchHasMoved = false;
        touchStartTime = Date.now();
        container.classList.add('dragging');
    });
    
    container.addEventListener('touchmove', (e) => {
        if (!touchStartX) return;
        e.preventDefault();
        
        const x = e.touches[0].pageX;
        const walk = (touchStartX - x) * 2;
        
        if (Math.abs(walk) > 10) {
            touchHasMoved = true;
            container.scrollLeft = touchScrollLeft + walk;
        }
    });
    
    container.addEventListener('touchend', (e) => {
        if (!touchHasMoved && (Date.now() - touchStartTime) < 200) {
            const thumbnailItem = e.target.closest('.thumbnail-item');
            if (thumbnailItem) {
                thumbnailItem.click();
            }
        }
        
        touchStartX = 0;
        container.classList.remove('dragging');
    });
    
    // Mouse wheel ile kaydırma
    container.addEventListener('wheel', (e) => {
        e.preventDefault();
        container.scrollLeft += e.deltaY;
    });
}

// Responsive tasarım yardımcıları
function adjustForMobile() {
    const isMobile = window.innerWidth < 768;
    document.body.classList.toggle('mobile-view', isMobile);
    return isMobile;
}

// Sayfa başlatma
document.addEventListener('DOMContentLoaded', function() {
    // Kitap numarasını ve toplam sayfa sayısını ayarla
    const scripts = document.getElementsByTagName('script');
    for (let script of scripts) {
        if (script.src.includes('common-functions.js') && !window.kitapNo) {
            const match = script.src.match(/\/([^\/]+)\/common-functions\.js/);
            if (match && match[1] !== 'app' && match[1] !== 'resources') {
                window.kitapNo = match[1];
            }
        }
    }
    
    // Toplam sayfa sayısını HTML'den al veya varsayılan olarak ayarla
    const pageInputElement = document.getElementById('current-page-input');
    if (pageInputElement) {
        window.totalPages = parseInt(pageInputElement.getAttribute('max')) || 42;
    } else {
        window.totalPages = 42; // Varsayılan değer
    }
    
    // Tüm fonksiyonları window objesine ekle
    window.getpage = getpage;
    window.toggleDrawingToolbox = toggleDrawingToolbox;
    window.showFeedback = showFeedback;
    window.saveCanvasState = saveCanvasState;
    window.initCanvasForPage = initCanvasForPage;
    window.jumpToCurrentPage = jumpToCurrentPage;
    window.zoomPageIn = zoomPageIn;
    window.zoomPageOut = zoomPageOut;
    window.resetPageZoom = resetPageZoom;
    window.applyZoom = applyZoom;
    window.togglePageSelector = togglePageSelector;
    window.openVideoModal = openVideoModal;
    window.openAudioModal = openAudioModal;
    window.openPaintingModal = openPaintingModal;
    window.openActivityModal = openActivityModal;
    window.openCircleMarkModal = openCircleMarkModal;
    
    window.clearAllDrawings = clearAllDrawings;
    window.initDirectDrawing = initDirectDrawing;
    window.playSound = playSound;
    window.playVideo = playVideo;
    window.showVideoModal = showVideoModal;
    window.closeVideoModal = closeVideoModal;
    window.closeAudioModal = closeAudioModal;
    window.closeBookSelector = closeBookSelector;
    window.toggleDoublePage = toggleDoublePage;
    window.updateSecondPage = updateSecondPage;
    window.addDoublePageStyles = addDoublePageStyles;
    window.removeDoublePageStyles = removeDoublePageStyles;
    window.applyDoublePageDirectStyles = applyDoublePageDirectStyles;
    window.restoreSinglePageStyles = restoreSinglePageStyles;
    window.playPageAudio = playPageAudio;
    window.playBackgroundMusic = playBackgroundMusic;
    window.stopBackgroundMusic = stopBackgroundMusic;
    window.showLoader = showLoader;
    window.hideLoader = hideLoader;
    window.saveDrawing = saveDrawing;
    window.initDrawingTools = initDrawingTools;
    window.initializeDrawingTools = initializeDrawingTools;
    window.setupDrawingCanvasWithHistory = setupDrawingCanvasWithHistory;
    window.setupDrawingButtons = setupDrawingButtons;
    window.drawShape = drawShape;
    window.loadThumbnails = loadThumbnails;
    window.initializeThumbnailDragging = initializeThumbnailDragging;
    window.isDoublePage = false;
    
    adjustForMobile();
    initDrawingTools();
    window.addEventListener('resize', adjustForMobile);
    
    // Enter tuşu ile sayfa atlama
    const pageInput = document.getElementById('current-page-input');
    if (pageInput) {
        pageInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                jumpToCurrentPage();
            }
        });
    }
    
    // İlk canvas'ı başlat ve gelişmiş çizim sistemi
    setTimeout(() => {
        initCanvasForPage('drawingCanvas');
        if (typeof initializeDrawingTools === 'function') {
            initializeDrawingTools();
        }
    }, 500);
});

// Gelişmiş çizim sistemi - ŞEKİL DESTEKLİ (1/index.html ile aynı)
function initDirectDrawing(canvas) {
    const canvasId = canvas.id;
    
    // Önceki event listener'ları temizle (güvenli yöntem)
    if (canvas._drawingEventsAttached) {
        return; // Zaten event'ler eklenmiş
    }
    canvas._drawingEventsAttached = true;
    
    let isDrawing = false;
    let lastX = 0, lastY = 0, startX = 0, startY = 0;
    let tempImageData = null;

    function startDrawing(e) {
        // Büyüteç aktifken veya araç seçilmemişken çizim yapma
        if (!window.currentTool) {
            return;
        }
        
        isDrawing = true;
        const rect = canvas.getBoundingClientRect();
        const clientX = e.clientX || (e.touches && e.touches[0].clientX);
        const clientY = e.clientY || (e.touches && e.touches[0].clientY);
        
        // Koordinat dönüşümü - zoom'u hesaba kat
        const normX = (clientX - rect.left) / rect.width;
        const normY = (clientY - rect.top) / rect.height;
        
        lastX = normX * (canvas.width / 2);
        lastY = normY * (canvas.height / 2);
        startX = lastX;
        startY = lastY;

        const ctx = canvas.getContext('2d');
        const currentTool = window.currentTool;
        
        // Her araç için ayrı ayarlar
        if (currentTool === 'highlighter') {
            // Fosforlu kalem - gerçek fosforlu kalem gibi
            ctx.globalCompositeOperation = 'multiply';
            ctx.globalAlpha = 0.25;
            ctx.strokeStyle = window.currentColor || '#FFD700';
            ctx.lineWidth = 25;
        } else if (currentTool === 'circle' || currentTool === 'shape') {
            // Daire ve şekil çizim araçları için ayarlar
            ctx.globalCompositeOperation = 'source-over';
            ctx.globalAlpha = 1.0;
            ctx.strokeStyle = window.currentColor;
            ctx.lineWidth = 3;
        } else {
            ctx.globalCompositeOperation = currentTool === 'eraser' ? 'destination-out' : 'source-over';
            ctx.globalAlpha = 1.0;
            ctx.strokeStyle = window.currentColor;
            
            if (currentTool === 'pen') {
                ctx.lineWidth = 2;
            } else if (currentTool === 'line') {
                ctx.lineWidth = 3;
            } else if (currentTool === 'brush') {
                ctx.lineWidth = 8;
            } else if (currentTool === 'eraser') {
                ctx.lineWidth = 15;
            } else {
                ctx.lineWidth = 6;
            }
        }

        ctx.lineCap = 'round';
        ctx.lineJoin = 'round';

        // Şekil çizim modları için geçici durum kaydet (Excel tarzı preview için)
        if (currentTool === 'line' || currentTool === 'circle' || currentTool === 'shape') {
            tempImageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
        }

        // Sürekli çizim araçları için çizimi başlat (sadece pen, brush, highlighter, eraser)
        if (currentTool === 'pen' || currentTool === 'brush' || currentTool === 'highlighter' || currentTool === 'eraser') {
            ctx.beginPath();
            ctx.moveTo(lastX, lastY);
        }

        // Aktif canvas'ı ayarla
        window.lastActiveCanvas = canvasId;
    }

    function draw(e) {
        if (!isDrawing) return;

        const rect = canvas.getBoundingClientRect();
        const clientX = e.clientX || (e.touches && e.touches[0].clientX);
        const clientY = e.clientY || (e.touches && e.touches[0].clientY);
        
        // Koordinat dönüşümü - zoom'u hesaba kat
        const normX = (clientX - rect.left) / rect.width;
        const normY = (clientY - rect.top) / rect.height;
        
        const currentX = normX * (canvas.width / 2);
        const currentY = normY * (canvas.height / 2);

        const ctx = canvas.getContext('2d');
        const currentTool = window.currentTool || 'pen';

        if (currentTool === 'line') {
            // Çizgi: önceki durumu geri yükle ve yeni çizgiyi çiz
            if (tempImageData) {
                ctx.putImageData(tempImageData, 0, 0);
            }
            ctx.beginPath();
            ctx.moveTo(startX, startY);
            ctx.lineTo(currentX, currentY);
            ctx.stroke();
        } else if (currentTool === 'circle') {
            // Daire: önceki durumu geri yükle ve yeni daireyi çiz
            if (tempImageData) {
                ctx.putImageData(tempImageData, 0, 0);
            }
            
            const radius = Math.sqrt(Math.pow(currentX - startX, 2) + Math.pow(currentY - startY, 2));
            ctx.beginPath();
            ctx.arc(startX, startY, radius, 0, 2 * Math.PI);
            ctx.stroke();
        } else if (currentTool === 'shape') {
            // Şekil çizim modları - 1/index.html ile aynı
            if (tempImageData) {
                ctx.putImageData(tempImageData, 0, 0);
            }
            
            const shape = window.currentShape || 'circle';
            drawShape(ctx, shape, startX, startY, currentX, currentY);
        } else if (currentTool === 'pen' || currentTool === 'brush' || currentTool === 'highlighter' || currentTool === 'eraser') {
            // Sürekli çizim (sadece pen, brush, highlighter, eraser)
            ctx.lineTo(currentX, currentY);
            ctx.stroke();
            ctx.beginPath();
            ctx.moveTo(currentX, currentY);
        }
        // Şekil araçları için hiçbir sürekli çizim yapma - sadece preview
    }

    function stopDrawing() {
        if (isDrawing) {
            isDrawing = false;
            tempImageData = null;
            
            // Global ayarları sıfırla
            const ctx = canvas.getContext('2d');
            ctx.globalCompositeOperation = 'source-over';
            ctx.globalAlpha = 1.0;
            
            // Çizim tamamlandığında state'i kaydet
            saveCanvasState(canvasId);
            console.log('✅ Çizim tamamlandı, state kaydedildi: ' + canvasId);
        }
    }

    canvas.addEventListener('mousedown', startDrawing);
    canvas.addEventListener('mousemove', draw);
    canvas.addEventListener('mouseup', stopDrawing);
    canvas.addEventListener('mouseout', stopDrawing);
    canvas.addEventListener('touchstart', (e) => { e.preventDefault(); startDrawing(e); });
    canvas.addEventListener('touchmove', (e) => { e.preventDefault(); draw(e); });
    canvas.addEventListener('touchend', (e) => { e.preventDefault(); stopDrawing(); });
}

// Şekil çizim fonksiyonu - 1/index.html'den tam kopyası
function drawShape(ctx, shape, startX, startY, endX, endY) {
    const width = endX - startX;
    const height = endY - startY;
    const centerX = startX + width / 2;
    const centerY = startY + height / 2;
    
    // Context'i temizle ve Excel tarzı ayarlara getir
    ctx.save();
    ctx.globalCompositeOperation = 'source-over';
    ctx.lineCap = 'round';
    ctx.lineJoin = 'round';
    
    switch(shape) {
        case 'arrow':
            // Ok çizimi - Excel benzeri tek path
            const arrowLength = Math.sqrt(width * width + height * height);
            const angle = Math.atan2(height, width);
            const arrowHeadLength = Math.min(arrowLength * 0.3, 20);
            
            ctx.beginPath();
            // Ana çizgi
            ctx.moveTo(startX, startY);
            ctx.lineTo(endX, endY);
            // Ok başı - sol kanat
            ctx.moveTo(endX, endY);
            ctx.lineTo(
                endX - arrowHeadLength * Math.cos(angle - Math.PI / 6),
                endY - arrowHeadLength * Math.sin(angle - Math.PI / 6)
            );
            // Ok başı - sağ kanat
            ctx.moveTo(endX, endY);
            ctx.lineTo(
                endX - arrowHeadLength * Math.cos(angle + Math.PI / 6),
                endY - arrowHeadLength * Math.sin(angle + Math.PI / 6)
            );
            ctx.stroke();
            break;
            
        case 'circle':
            // Daire - Excel tarzı tek path
            const circleRadius = Math.sqrt(width * width + height * height) / 2;
            ctx.beginPath();
            ctx.arc(centerX, centerY, circleRadius, 0, 2 * Math.PI);
            ctx.stroke();
            break;
            
        case 'rectangle':
            // Dikdörtgen - Excel tarzı
            ctx.beginPath();
            ctx.strokeRect(Math.min(startX, endX), Math.min(startY, endY), Math.abs(width), Math.abs(height));
            break;
            
        case 'triangle':
            // Üçgen - Excel tarzı tek path
            const triangleHeight = Math.abs(height);
            const triangleWidth = Math.abs(width);
            
            ctx.beginPath();
            if (width >= 0 && height >= 0) {
                ctx.moveTo(startX, startY);
                ctx.lineTo(startX - triangleWidth / 2, startY + triangleHeight);
                ctx.lineTo(startX + triangleWidth / 2, startY + triangleHeight);
                ctx.closePath();
            } else if (width < 0 && height >= 0) {
                ctx.moveTo(startX, startY);
                ctx.lineTo(startX + triangleWidth / 2, startY + triangleHeight);
                ctx.lineTo(startX - triangleWidth / 2, startY + triangleHeight);
                ctx.closePath();
            } else if (width >= 0 && height < 0) {
                ctx.moveTo(startX, startY);
                ctx.lineTo(startX - triangleWidth / 2, startY - triangleHeight);
                ctx.lineTo(startX + triangleWidth / 2, startY - triangleHeight);
                ctx.closePath();
            } else {
                ctx.moveTo(startX, startY);
                ctx.lineTo(startX + triangleWidth / 2, startY - triangleHeight);
                ctx.lineTo(startX - triangleWidth / 2, startY - triangleHeight);
                ctx.closePath();
            }
            ctx.stroke();
            break;
            
        case 'filledcircle':
            // Dolu Daire - içi dolu
            const filledRadius = Math.sqrt(width * width + height * height) / 2;
            ctx.fillStyle = ctx.strokeStyle;
            ctx.beginPath();
            ctx.arc(centerX, centerY, filledRadius, 0, 2 * Math.PI);
            ctx.fill();
            break;
            
        default:
            // Varsayılan daire
            const radius = Math.sqrt(width * width + height * height) / 2;
            ctx.beginPath();
            ctx.arc(centerX, centerY, radius, 0, 2 * Math.PI);
            ctx.stroke();
    }
    
    ctx.restore();
}

// BÜYÜTEÇ SİSTEMİ GLOBAL DEĞİŞKENLERİ VE FONKSİYONLARI
let magnifierActive = false;
let magnifiedArea = null;
let magnifiedContent = null;
let targetElement = null;

function toggleMagnifier() {
    const magnifierBtn = document.querySelector('.magnifier-tool-btn');
    
    if (!magnifierActive) {
        // Büyüteci aktif et
        magnifierActive = true;
        
        // ÖNCEKİ ÇİZİM ARACINI DEVRE DIŞI BIRAK
        window.previousTool = window.currentTool;
        window.currentTool = null;
        window.currentDrawingMode = null;
        
        // Tüm diğer araç butonlarının aktif sınıfını kaldır
        document.querySelectorAll('.drawing-tool-btn').forEach(btn => {
            btn.classList.remove('active');
        });
        document.querySelectorAll('.shape-tool-btn').forEach(btn => {
            btn.classList.remove('active');
        });
        
        if (magnifierBtn) magnifierBtn.classList.add('active');
        document.body.classList.add('magnifier-active');
        
        // Canvas'ların pointer-events'ini geçici olarak devre dışı bırak
        const allCanvases = document.querySelectorAll('canvas[id*="drawing"]');
        allCanvases.forEach(canvas => {
            canvas.style.pointerEvents = 'none';
        });
        
        // Sadece büyütülmüş alan elemanlarını hazırla
        magnifiedArea = document.getElementById('magnifiedArea');
        magnifiedContent = document.getElementById('magnifiedContent');
        
        if (!magnifiedArea) {
            magnifiedArea = document.createElement('div');
            magnifiedArea.id = 'magnifiedArea';
            magnifiedArea.className = 'magnified-area';
            magnifiedArea.style.cssText = 'position: fixed; width: 500px; height: 500px; border: 4px solid #4F46E5; border-radius: 50%; background: white; pointer-events: none; z-index: 10000; display: none; overflow: hidden; box-shadow: 0 15px 40px rgba(0,0,0,0.4);';
            
            magnifiedContent = document.createElement('div');
            magnifiedContent.id = 'magnifiedContent';
            magnifiedContent.className = 'magnified-content';
            magnifiedContent.style.cssText = 'position: absolute; transform-origin: top left; pointer-events: none;';
            
            magnifiedArea.appendChild(magnifiedContent);
            document.body.appendChild(magnifiedArea);
        }
        
        // Hedef elementi bul (sayfa görseli)
        targetElement = document.getElementById('sayfa');
        
        if (targetElement && magnifiedArea) {
            // Mouse event listener'ları ekle
            document.addEventListener('mousemove', handleMagnifierMove);
            document.addEventListener('click', handleMagnifierClick);
            
            showFeedback('🔍 Büyüteç aktif! Fareyi sayfada gezdirin. Tıklayarak kapatabilirsiniz.', 'success');
            console.log('🔍 Büyüteç aktifleştirildi');
        }
    } else {
        // Büyüteci deaktif et
        deactivateMagnifier();
    }
}

// Büyüteci deaktif etme fonksiyonu
function deactivateMagnifier() {
    const magnifierBtn = document.querySelector('.magnifier-tool-btn');
    
    magnifierActive = false;
    if (magnifierBtn) magnifierBtn.classList.remove('active');
    document.body.classList.remove('magnifier-active');
    
    if (magnifiedArea) magnifiedArea.style.display = 'none';
    
    // Event listener'ları kaldır
    document.removeEventListener('mousemove', handleMagnifierMove);
    document.removeEventListener('click', handleMagnifierClick);
    
    // Canvas'ların pointer-events'ini tekrar aktif et
    const allCanvases = document.querySelectorAll('canvas[id*="drawing"]');
    allCanvases.forEach(canvas => {
        canvas.style.pointerEvents = 'auto';
    });
    
    // Önceki çizim aracını geri yükle
    if (window.previousTool) {
        window.currentTool = window.previousTool;
        window.currentDrawingMode = window.previousTool;
        
        // İlgili butonu aktif et
        const prevBtn = document.querySelector('.drawing-tool-btn[data-tool="' + window.previousTool + '"]');
        if (prevBtn) prevBtn.classList.add('active');
    } else {
        // Varsayılan olarak kalemi seç
        window.currentTool = 'pen';
        window.currentDrawingMode = 'pen';
        const penBtn = document.querySelector('.drawing-tool-btn[data-tool="pen"]');
        if (penBtn) penBtn.classList.add('active');
    }
    
    showFeedback('🔍 Büyüteç kapatıldı', 'info');
    console.log('🔍 Büyüteç deaktifleştirildi');
}

// Mouse hareket fonksiyonu
function handleMagnifierMove(e) {
    if (!magnifierActive) return;
    
    // Sürekli mouse pozisyonunu takip et
    let currentTarget = null;
    let currentRect = null;
    
    // İlk sayfayı kontrol et
    const sayfa1 = document.getElementById('sayfa');
    if (sayfa1) {
        const rect1 = sayfa1.getBoundingClientRect();
        if (e.clientX >= rect1.left && e.clientX <= rect1.right && 
            e.clientY >= rect1.top && e.clientY <= rect1.bottom) {
            currentTarget = sayfa1;
            currentRect = rect1;
            window.lastActiveCanvas = 'drawingCanvas';
        }
    }
    
    // Çift sayfa modunda ikinci sayfayı kontrol et
    if (!currentTarget && window.dimli % 2 === 0) {
        const sayfa2 = document.getElementById('sayfa2');
        if (sayfa2 && !sayfa2.classList.contains('hidden')) {
            const rect2 = sayfa2.getBoundingClientRect();
            if (e.clientX >= rect2.left && e.clientX <= rect2.right && 
                e.clientY >= rect2.top && e.clientY <= rect2.bottom) {
                currentTarget = sayfa2;
                currentRect = rect2;
                window.lastActiveCanvas = 'drawingCanvas2';
            }
        }
    }
    
    if (currentTarget && currentRect) {
        targetElement = currentTarget;
        // Her mouse hareketi için büyütülmüş alanı güncelle
        showMagnifiedArea(e, currentRect);
    } else {
        // Mouse hiçbir sayfanın üzerinde değil
        if (magnifiedArea) magnifiedArea.style.display = 'none';
    }
}

// Büyütülmüş alan gösterme fonksiyonu
function showMagnifiedArea(e, targetRect) {
    if (!magnifiedArea || !magnifiedContent || !targetElement) return;
    
    const mouseX = e.clientX;
    const mouseY = e.clientY;
    const areaSize = 400; // Büyüteç boyutu
    const zoomLevel = 2.5; // Büyütme oranı
    
    // Büyütülmüş alanın pozisyonunu hesapla (mouse'un yakınında ama üstünde değil)
    let areaX = mouseX + 30; // Mouse'un sağında
    let areaY = mouseY - areaSize - 30; // Mouse'un üstünde
    
    // Ekran sınırlarını kontrol et
    if (areaX + areaSize > window.innerWidth - 10) {
        areaX = mouseX - areaSize - 30; // Sağ tarafta sığmıyorsa sol tarafa al
    }
    if (areaY < 10) {
        areaY = mouseY + 30; // Üstte sığmıyorsa alta al
    }
    if (areaX < 10) {
        areaX = 10;
    }
    if (areaY + areaSize > window.innerHeight - 10) {
        areaY = window.innerHeight - areaSize - 10;
    }
    
    // Büyüteç alanını mouse'u takip ettir
    magnifiedArea.style.width = areaSize + 'px';
    magnifiedArea.style.height = areaSize + 'px';
    magnifiedArea.style.left = areaX + 'px';
    magnifiedArea.style.top = areaY + 'px';
    magnifiedArea.style.display = 'block';
    
    // Mouse'un sayfa üzerindeki pozisyonunu hesapla
    const relativeX = mouseX - targetRect.left;
    const relativeY = mouseY - targetRect.top;
    
    // Büyütülmüş içeriğin pozisyonunu hesapla
    const offsetX = (relativeX * zoomLevel) - (areaSize / 2);
    const offsetY = (relativeY * zoomLevel) - (areaSize / 2);
    
    // İçeriği temizle ve yeniden oluştur
    magnifiedContent.innerHTML = '';
    magnifiedContent.style.width = areaSize + 'px';
    magnifiedContent.style.height = areaSize + 'px';
    magnifiedContent.style.overflow = 'hidden';
    
    // İçerik container'ı oluştur
    const contentContainer = document.createElement('div');
    contentContainer.style.position = 'relative';
    contentContainer.style.width = (targetRect.width * zoomLevel) + 'px';
    contentContainer.style.height = (targetRect.height * zoomLevel) + 'px';
    contentContainer.style.left = -offsetX + 'px';
    contentContainer.style.top = -offsetY + 'px';
    
    // Sayfa resminin klonunu oluştur
    const imgClone = targetElement.cloneNode(true);
    imgClone.style.position = 'absolute';
    imgClone.style.width = '100%';
    imgClone.style.height = '100%';
    imgClone.style.left = '0';
    imgClone.style.top = '0';
    imgClone.style.pointerEvents = 'none';
    imgClone.style.imageRendering = 'crisp-edges'; // Keskin görüntü
    contentContainer.appendChild(imgClone);
    
    // Canvas'ı da büyüt
    const activeCanvas = document.getElementById(window.lastActiveCanvas || 'drawingCanvas');
    if (activeCanvas && activeCanvas.getContext) {
        const canvasClone = document.createElement('canvas');
        canvasClone.style.position = 'absolute';
        canvasClone.style.width = '100%';
        canvasClone.style.height = '100%';
        canvasClone.style.left = '0';
        canvasClone.style.top = '0';
        canvasClone.style.pointerEvents = 'none';
        
        // Canvas boyutlarını orijinal canvas ile aynı yap
        const originalWidth = activeCanvas.width;
        const originalHeight = activeCanvas.height;
        canvasClone.width = originalWidth;
        canvasClone.height = originalHeight;
        
        // Canvas içeriğini kopyala
        const ctx = canvasClone.getContext('2d');
        ctx.imageSmoothingEnabled = false; // Piksel mükemmelliği için
        try {
            ctx.drawImage(activeCanvas, 0, 0, originalWidth, originalHeight);
        } catch(err) {
            console.log('Canvas kopyalama hatası:', err);
        }
        
        contentContainer.appendChild(canvasClone);
    }
    
    magnifiedContent.appendChild(contentContainer);
}

// Tıklama ile büyüteci kapatma
function handleMagnifierClick(e) {
    // Eğer büyüteç butonuna tıklanmadıysa büyüteci kapat
    if (!e.target.closest('.magnifier-tool-btn')) {
        deactivateMagnifier();
    }
}

// Global fonksiyonları window objesine ata
window.toggleMagnifier = toggleMagnifier;
window.deactivateMagnifier = deactivateMagnifier;
window.magnifierActive = false;

// SORU BUTONLARI SISTEMI
// Sayfa yuklenene kadar bekle (window.soruKonumlari tanimlansin)
setTimeout(function() {
    if (window.soruKonumlari && window.cevapVarMi) {
        console.log('Soru butonlari sistemi aktif!');
        
        window.soruButonlariOlustur = function(sayfaNo, containerNo) {
        var container = document.getElementById('questionButtonsContainer' + containerNo);
        if (!container) return;
        container.innerHTML = '';
        var sayfaKey = 'sayfa_' + (sayfaNo < 10 ? '0' + sayfaNo : sayfaNo);
        var sorular = window.soruKonumlari[sayfaKey];
        if (!sorular) return;
        
        for (var i = 0; i < sorular.length; i++) {
            var soru = sorular[i];
            var btn = document.createElement('button');
            btn.style.cssText = 'position:absolute;left:'+soru.x+'%;top:'+soru.y+'%;width:35px;height:35px;background:linear-gradient(135deg,#22c55e,#16a34a);color:white;border:2px solid white;border-radius:8px;cursor:pointer;z-index:100;display:flex;align-items:center;justify-content:center;box-shadow:0 3px 10px rgba(34,197,94,0.5)';
            btn.innerHTML = '<i class="fas fa-check"></i>';
            
            // OVERLAY - tam sayfa boyutunda
            var overlay = document.createElement('div');
            overlay.style.cssText = 'position:absolute;left:0;top:0;width:100%;height:100%;z-index:999;display:none;pointer-events:none';
            
            // IMG - clip-path ile crop
            var img = new Image();
            var imgSrc = 'pages/images/answers/'+(window.kitapNo||'1')+'_Cevap_'+(sayfaNo<10?'0'+sayfaNo:sayfaNo)+'.png';
            
            img.onload = (function(ovr,soru){return function(){
                var clipTop = soru.y;
                var clipRight = 100 - soru.x - soru.width;
                var clipBottom = 100 - soru.y - soru.height;
                var clipLeft = soru.x;
                this.style.cssText = 'position:absolute;left:0;top:0;width:100%;height:100%;object-fit:contain;clip-path:inset('+clipTop+'% '+clipRight+'% '+clipBottom+'% '+clipLeft+'%)';
                ovr.appendChild(this);
            }})(overlay,soru);
            img.src = imgSrc;
            
            // BUTON ONCLICK - Toggle ile renk degisimi
            btn.onclick = (function(o,c,b){return function(){
                var isOpen = o.style.display === 'block';
                
                // Tum overlay'leri kapat
                var all=c.querySelectorAll('div[style*="z-index: 999"]');
                for(var j=0;j<all.length;j++)all[j].style.display='none';
                
                // Toggle: Aciksa kapat, kapaliysa ac
                if (!isOpen) {
                    o.style.display='block';
                }
            }})(overlay,container,btn);
            
            container.appendChild(btn);
            container.appendChild(overlay);
        }
        console.log(sorular.length + ' soru butonu eklendi');
    };
    
        // Sayfa yuklendiginde otomatik cagir
        setTimeout(function() {
            if (document.getElementById('questionButtonsContainer1')) {
                window.soruButonlariOlustur(window.dimli || 1, 1);
                console.log('Soru butonlari otomatik yuklendi!');
            }
        }, 2000);
    }
}, 500);
